#include <algorithm>
#include <iostream>
#include <vector>

struct Offer {
  int idx;
  int weight;
  int value;
  float rating;
} pom;

std::vector<Offer> offers;
bool cmpRating(const Offer &a, const Offer &b) { return a.rating < b.rating; }
bool cmpIndex(const Offer &a, const Offer &b) { return a.idx < b.idx; }

int main() {
  int n, W;
  float epsilon;
  std::cin >> n >> W >> epsilon;

  for (int i = 0, w, v; i < n; i++) {
    pom.idx = i + 1;
    std::cin >> pom.weight >> pom.value;
    pom.rating = (float)pom.value / ((float)pom.weight);
    offers.push_back(pom);
  }
  std::sort(offers.begin(), offers.end(), cmpRating);

  int weight = 0;
  int value = 0;
  std::vector<Offer> rez;
  for (auto &offer : offers) {
    if (weight + offer.weight > W) {
      if (offer.value > value) {
        std::cout << "1\n";
        std::cout << offer.idx;
        return 0;
      } else {
        break;
      }
    }
    weight += offer.weight;
    value += offer.value;
    rez.push_back(offer);
  }

  std::cout << rez.size() << "\n";
  for (auto &offer : rez) {
    std::cout << offer.idx << " ";
  }
  return 0;
}